<?php
$watermark_img = get_option('ulz_watermark_img');

// Remove escape characters
$watermark_img = stripslashes($watermark_img);

// Decode the JSON string
$decoded_data = json_decode($watermark_img, true);

// Check if decoding was successful and retrieve the ID
if (!empty($decoded_data) && isset($decoded_data[0]['id'])) {
    $id = $decoded_data[0]['id'];
    // Get the GUID of the post (URL of the watermark)
    $watermark_path = wp_get_attachment_url($id);
} else {
    $watermark_path = ''; // Set to empty if no valid watermark exists
}
?>

<div class="ulz-modal ulz-modal-gallery ulz-no-select" data-id="gallery">
    <?php Ucore()->the_template('modals/close'); ?>
    <div class="ulz-modal-heading">
        <h4 class="ulz--title">&nbsp;</h4>
    </div>
    <div class="ulz-modal-content">
        <div class="ulz-modal-image">
            <!-- append image here -->
        </div>
        <?php if (!empty($watermark_path)): ?>
        <img class="ulz--watermark" src="<?php echo $watermark_path; ?>" alt="Watermark" style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); pointer-events: none; max-width: 25%; opacity: 0.5;">
        <?php endif; ?>
        <a href="#" class="ulz-gallery-nav" data-action="prev">
            <span><i class="fas fa-arrow-left"></i></span>
        </a>
        <a href="#" class="ulz-gallery-nav" data-action="next">
            <span><i class="fas fa-arrow-right"></i></span>
        </a>
        <?php Ucore()->preloader(); ?>
    </div>
    <div class="ulz-gallery-counter">
        <span class="ulz--current"></span>&nbsp;&sol;&nbsp;<span class="ulz--total"></span>
    </div>
</div>